import numpy as np
import math
import integerToWords_fr
import sys

def primesfrom2to(n):
    """ Input n>=6, Returns a array of primes, 2 <= p < n """
    sieve = np.ones(n/3 + (n%6==2), dtype=np.bool)
    for i in xrange(1,int(n**0.5)/3+1):
        if sieve[i]:
            k=3*i+1|1
            sieve[       k*k/3     ::2*k] = False
            sieve[k*(k-2*(i&1)+4)/3::2*k] = False
    return np.r_[2,3,((3*np.nonzero(sieve)[0][1:]+1)|1)]

def fp(nombre):
    t = np.searchsorted(premiers, nombre) + 1
    ret = np.zeros(t, dtype='i')
    q = nombre
    for i in range(0, t):
        if q == 1:
            break
        p = premiers[i]
        while q%p == 0:
            ret[i] += 1
            q /= p
    return ret

def chiffres(nombre):
    s = int(math.log10(nombre))+1
    ret = np.zeros(s, dtype='i')
    for i in range(0, s):
        ret[i] = np.mod(nombre, 10**(i+1))/10**i
    return ret

def nombre(chiffres):
    s = len(chiffres)
    ret = 0
    for i in range(0, s):
        ret += chiffres[i]*10**i
    return ret

def test1():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
	    ct = np.sort(c)
	    pg = nombre(ct)
	    pp = nombre(ct[::-1])
            if pg-n < n-pp:
                nombres[n] = 0

def test2():
    for n in range(0, len(nombres)):
##         if n%10000 == 0:
##             print"\t"+str(n)
        if nombres[n] == 0:
            continue
        else:
##             f = math.factorial(n)
##             d = f / 10**(int(math.log10(f))-1)
##             if (d%10+d/10)%2 == 0:
##                 nombres[n] = 0
            r1 = math.sqrt(2*math.pi*n)
            r2a = n*math.log10(n/math.e)
            r2b = 10**(r2a%1)
            r = r1*r2b
            d = int(r / 10**(int(math.log10(r))-1))
            if (d%10+d/10)%2 == 0:
                nombres[n] = 0


def test3():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            c2 = chiffres(n**2)
            if (sum(c)+sum(c2))%2 == 0:
                nombres[n] = 0

def test4():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            sdc = sum(c)
            p1 = np.searchsorted(premiers, n-sdc)
            p2 = np.searchsorted(premiers, n+sdc+1)
            if p2 - p1 not in premiers:
                nombres[n] = 0

def test5():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            if np.product(c) >= sum(c):
                nombres[n] = 0

def test6():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            v = int(math.log(n))
            if v in premiers:
                nombres[n] = 0

def test7():
    global m
    global i
    global p
    for n in range(0, len(nombres)):
##         if n%10000 == 0:
##             print"\t"+str(n)
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            i = 5*[-1]
            m = -1
            p = 0
            def melange():
                global m
                global i
                global p
                m += 1
                if m < 5:
                    l = 10*[0]
                    for i[m] in range(0, 5):
                        if i.count(i[m]) == 1:
                            if l[c[i[m]]] == 0:
                                l[c[i[m]]] = 1
                                melange()
                    i[m] = -1
                elif m == 5:
                    if nombre(c[i]) in premiers:
                        p += 1
                m -= 1
            melange()
            if p not in premiers:
                nombres[n] = 0

def test8():
##     gagnant = np.load('gagnant.npy')

    gagnant = np.zeros(100000, dtype='i')
    for i in range(0, len(gagnant)):
##         if i%10000 == 0:
##             print i
        b = np.searchsorted(premiers, i+1)
        for j in range(0, b)[::-1]:
            if gagnant[i-premiers[j]] == 0:
                gagnant[i] = 1
                break
    
##     np.save('gagnant',gagnant)
    
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            if gagnant[n] == 1:
                nombres[n] = 0

def test9():
    hl = ['a','b','c','d','e','f']
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            ns = '%x' % n
            h = 0
            a = 0
            for i in range(0, len(ns)):
                if ns[i] in hl:
                    h += 1
                else:
                    a += 1
            if h > a:
                nombres[n] = 0

def test10():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            if int(n**(1./3)) in premiers:
                nombres[n] = 0

def test11():
    vs = ['a','e','i','o','u']
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            v = 0
            nl = integerToWords_fr.printer(n)
            for i in range(0, len(nl)):
                if nl[i] in vs:
                    v += 1
            if v%2 == 0:
                nombres[n] = 0

def test12():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            continue
            # a coder

def test13():
    seg = np.array([6,2,5,5,4,5,6,3,7,6])
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            s = sum(seg[c])
            if s%6 == 0:
                nombres[n] = 0

def test14():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            if 0 in c[1:]-c[:-1]:
                nombres[n] = 0

def test15():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            while len(c) > 1:
                c = chiffres(sum(c))
            if c[0]%2 == 0:
                nombres[n] = 0

def test16():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            if max(c) != 8:
                nombres[n] = 0

def test17():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            if (sum(c)+n)%2 != 0:
                nombres[n] = 0

def test18():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            c = chiffres(n)
            rcub = sum(c)**(1./3)
            if rcub == int(rcub):
                nombres[n] = 0

def test19():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            nc = n
            t = 1
            while nc != 1:
                t += 1
                if nc%2 == 0:
                    nc = nc/2
                else:
                    nc = 3*nc+1
            if t%2 == 0:
                nombres[n] = 0

def test20():
    for n in range(0, len(nombres)):
        if nombres[n] == 0:
            continue
        else:
            if n in premiers:
                nombres[n] = 0



ntest = 0
for arg in sys.argv:
    if arg.isdigit() and int(arg) < 100000:
        ntest = int(arg)

premiers = primesfrom2to(100000)
nombres = np.ones(100000, dtype='i')
nombres[0:10000] = np.zeros(10000)
## nombres=np.load('nombres4.npy')
questions = {1 : test1,
            2 : test2,
            3 : test3,
            4 : test4,
            5 : test5,
            6 : test6,
            7 : test7,
            8 : test8,
            9 : test9,
            10 : test10,
            11 : test11,
            12 : test12,
            13 : test13,
            14 : test14,
            15 : test15,
            16 : test16,
            17 : test17,
            18 : test18,
            19 : test19,
            20 : test20,
}

ordre = ([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20])
## ordre = ([19])

for q in ordre:
    questions[q]()
    print q,sum(nombres)
    if ntest and nombres[ntest] == 0:
        break

## np.save('nombres4',nombres)
sols = np.nonzero(nombres)[0]
if len(sols) <= 16:
    print sols
